import os


output = open("script.sh", 'w')
directory = "."
filenames = os.listdir(directory)
for filename in sorted(filenames):
    library, extension = os.path.splitext(filename)
    if extension != ".fa":
        continue
    if library not in ("SRR7071452",
                       "SRR7071453",
                       "SRR7071454",
                       "SRR7071455"):
        continue
    script_name = "script_%s.sh" % library
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s.stderr
#SBATCH -o ./script_%s.stdout
#SBATCH --mem=4G
python make_sequence_index.py %s
""" % (library, library, library))
    handle.close()
    output.write('sbatch %s\n' % script_name)

output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
